require('dotenv').config();
const readline = require('readline');
const authService = require('../services/authService');

const rl = readline.createInterface({
    input: process.stdin,
    output: process.stdout
});

function question(query) {
    return new Promise(resolve => rl.question(query, resolve));
}

async function createAdmin() {
    try {
        console.log('\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
        console.log('  Create Admin User');
        console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n');

        const username = await question('Enter admin username (min 3 characters): ');

        if (username.length < 3) {
            console.error('❌ Username must be at least 3 characters');
            process.exit(1);
        }

        const password = await question('Enter admin password (min 6 characters): ');

        if (password.length < 6) {
            console.error('❌ Password must be at least 6 characters');
            process.exit(1);
        }

        const confirmPassword = await question('Confirm password: ');

        if (password !== confirmPassword) {
            console.error('❌ Passwords do not match');
            process.exit(1);
        }

        console.log('\nCreating admin user...');

        const user = await authService.createUser(username, password, 'admin');

        console.log('\n✅ Admin user created successfully!');
        console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
        console.log(`Username: ${user.username}`);
        console.log(`Role: ${user.role}`);
        console.log(`User ID: ${user.id}`);
        console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n');

        rl.close();
        process.exit(0);
    } catch (error) {
        console.error('\n❌ Error creating admin user:', error.message);
        rl.close();
        process.exit(1);
    }
}

createAdmin();
