const path = require('path');
require('dotenv').config({ path: path.join(__dirname, '.env') });
const fileService = require('./src/services/fileService');
const { supabase } = require('./src/config/database');

async function run() {
    console.log('Starting debug folder compression...');
    try {
        // 1. Get user
        const { data: users } = await supabase.from('users').select('id, username').limit(1);
        const user = users[0];

        // 2. Create a folder
        const folderName = `test-folder-${Date.now()}`;
        console.log(`Creating folder ${folderName}...`);
        const folder = await fileService.createFolder(folderName, '/', user.id, user.username);
        console.log('Folder created:', folder.id);

        // 2b. Add file to folder
        console.log('Adding file to folder...');
        await fileService.uploadFile({
            originalname: 'nested-file.txt',
            buffer: Buffer.from('Nested content'),
            mimetype: 'text/plain',
            size: 14
        }, `/${folderName}`, user.id, user.username);

        // 3. Compress the folder
        console.log('Attempting to compress folder...');
        try {
            await fileService.compressFiles([folder.id], 'folder-archive', '/', user.id, user.username);
            console.log('Compression successful!');
        } catch (e) {
            console.log('Caught expected error:');
            console.log(e.message);
        }

    } catch (error) {
        console.error('Script failed:', error);
    }
    process.exit(0);
}

run();
